;/* $Header: /lsid/semaphore/clarinet/custom/sigout_.h 1.6 1997/03/21 00:55:17 donm Exp $ */
;/* (C) Copyright 1996, Hewlett-Packard Company, all rights reserved. */
;/* */
;/* This is the unix version of the dos file. */
;/* Use "ux2dos' and "dos2ux" to convert. */

;/*######################################################################### */
;/*#### WARNING: THIS FILE IS USED BY CUSTOM SIGNAL MODES (srcusr.asm) ##### */
;/*######################################################################### */

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;  Status, Control and parameters common to all output modes

;	located in 6 bit memory for jset access
;	mode specific variables are to follow immediately

Fsigoutstatus		equ	y:$0000
;	Fsigoutstatus should be correct before rti
;	bit 23  turn frmsync off, stop, burst end, rampdown end
;	bit 22  dac overread
;	bit 21  set when signal mode is run (not waiting for triger)

Fsigoutcontrol		equ	y:$0001
;	bit  flags may be set on the fly, and is cleared elsewhere
;	23, sigoff, turn off both channels immediately
;	22, ramp2sigoff, do rampdown on both channels
;	21, trgoutflg, allow trigout on dynamic signal cmds, or each block
;		if in freerun
;	20, trgsrcflg (1=triggered, 0=freerun)
;
;	19, systrigflg (1=system trigger, 0=source trig) 
;	18, DF1700 out (1=df1700 out, 0=df1700 in)
;	17, 2 channelmode (1= 2 channels, 0= 1 channel)
;	16, ch1 on  (1 = ch1 is on, 0 = ch1 is off)
;
;	15, ch2 on  (1 = ch2 is on, 0 = ch2 is off)
;	14, off detected during wait for trigger, zeroing dsp,df
;	13, shutdown detected flag used by sigout only
;	12, overload detected flag used by sigout only
;
;	11, set to wait for sync on freerun start, main/sigout
;
;	2,  0 = non periodic; 1 = periodic (reset seed/rewind at end)
;
;	1,  0 = dont reset filters, on arm; 1 = reset filters, on arm.
;
;	0,  type of init: 0 = initial init, 1 = arm init.

Fsigoutxeqcmdflg	equ	y:$0002
;	xeqcmdflgin is set on the fly, and is cleared in sigout routine
;	It is sampled during channel 0 and and copied to xeqcmdflg
;	It is cleared after being read.
;	Setting this flag causes the execution of a dynamic command that
;	is waiting on it.
;	It may be set by a trigger in and used to syncronize changes.
;	Bit 23 is the actual flag

;;;;;;;  Mode specific variables to follow:






